package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  ErrorMessage,
  RoleArn,
  Timestamp,
  IndexId,
  Description,
  ThesaurusName,
  ThesaurusId
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeThesaurusResponse(
    id: Optional[ThesaurusId] = Optional.Absent,
    indexId: Optional[IndexId] = Optional.Absent,
    name: Optional[ThesaurusName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.ThesaurusStatus] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    sourceS3Path: Optional[zio.aws.kendra.model.S3Path] = Optional.Absent,
    fileSizeBytes: Optional[Long] = Optional.Absent,
    termCount: Optional[Long] = Optional.Absent,
    synonymRuleCount: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse = {
    import DescribeThesaurusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse
      .builder()
      .optionallyWith(
        id.map(value => ThesaurusId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        indexId.map(value => IndexId.unwrap(value): java.lang.String)
      )(_.indexId)
      .optionallyWith(
        name.map(value => ThesaurusName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(sourceS3Path.map(value => value.buildAwsValue()))(
        _.sourceS3Path
      )
      .optionallyWith(fileSizeBytes.map(value => value: java.lang.Long))(
        _.fileSizeBytes
      )
      .optionallyWith(termCount.map(value => value: java.lang.Long))(
        _.termCount
      )
      .optionallyWith(synonymRuleCount.map(value => value: java.lang.Long))(
        _.synonymRuleCount
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeThesaurusResponse.ReadOnly =
    zio.aws.kendra.model.DescribeThesaurusResponse.wrap(buildAwsValue())
}
object DescribeThesaurusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeThesaurusResponse =
      zio.aws.kendra.model.DescribeThesaurusResponse(
        id.map(value => value),
        indexId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        errorMessage.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        roleArn.map(value => value),
        sourceS3Path.map(value => value.asEditable),
        fileSizeBytes.map(value => value),
        termCount.map(value => value),
        synonymRuleCount.map(value => value)
      )
    def id: Optional[ThesaurusId]
    def indexId: Optional[IndexId]
    def name: Optional[ThesaurusName]
    def description: Optional[Description]
    def status: Optional[zio.aws.kendra.model.ThesaurusStatus]
    def errorMessage: Optional[ErrorMessage]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def roleArn: Optional[RoleArn]
    def sourceS3Path: Optional[zio.aws.kendra.model.S3Path.ReadOnly]
    def fileSizeBytes: Optional[Long]
    def termCount: Optional[Long]
    def synonymRuleCount: Optional[Long]
    def getId: ZIO[Any, AwsError, ThesaurusId] =
      AwsError.unwrapOptionField("id", id)
    def getIndexId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("indexId", indexId)
    def getName: ZIO[Any, AwsError, ThesaurusName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.ThesaurusStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSourceS3Path
        : ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("sourceS3Path", sourceS3Path)
    def getFileSizeBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fileSizeBytes", fileSizeBytes)
    def getTermCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("termCount", termCount)
    def getSynonymRuleCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("synonymRuleCount", synonymRuleCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse
  ) extends zio.aws.kendra.model.DescribeThesaurusResponse.ReadOnly {
    override val id: Optional[ThesaurusId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ThesaurusId(value))
    override val indexId: Optional[IndexId] = zio.aws.core.internal
      .optionalFromNullable(impl.indexId())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val name: Optional[ThesaurusName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ThesaurusName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val status: Optional[zio.aws.kendra.model.ThesaurusStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.ThesaurusStatus.wrap(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val sourceS3Path: Optional[zio.aws.kendra.model.S3Path.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceS3Path())
        .map(value => zio.aws.kendra.model.S3Path.wrap(value))
    override val fileSizeBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSizeBytes())
      .map(value => value: Long)
    override val termCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.termCount())
      .map(value => value: Long)
    override val synonymRuleCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.synonymRuleCount())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse
  ): zio.aws.kendra.model.DescribeThesaurusResponse.ReadOnly = new Wrapper(impl)
}
