package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{IndexId, ExperienceId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateEntitiesFromExperienceRequest(
    id: ExperienceId,
    indexId: IndexId,
    entityList: Iterable[zio.aws.kendra.model.EntityConfiguration]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceRequest = {
    import DisassociateEntitiesFromExperienceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceRequest
      .builder()
      .id(ExperienceId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .entityList(entityList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DisassociateEntitiesFromExperienceRequest.ReadOnly =
    zio.aws.kendra.model.DisassociateEntitiesFromExperienceRequest
      .wrap(buildAwsValue())
}
object DisassociateEntitiesFromExperienceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.DisassociateEntitiesFromExperienceRequest =
      zio.aws.kendra.model.DisassociateEntitiesFromExperienceRequest(
        id,
        indexId,
        entityList.map { item =>
          item.asEditable
        }
      )
    def id: ExperienceId
    def indexId: IndexId
    def entityList: List[zio.aws.kendra.model.EntityConfiguration.ReadOnly]
    def getId: ZIO[Any, Nothing, ExperienceId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getEntityList: ZIO[Any, Nothing, List[
      zio.aws.kendra.model.EntityConfiguration.ReadOnly
    ]] = ZIO.succeed(entityList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceRequest
  ) extends zio.aws.kendra.model.DisassociateEntitiesFromExperienceRequest.ReadOnly {
    override val id: ExperienceId =
      zio.aws.kendra.model.primitives.ExperienceId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val entityList
        : List[zio.aws.kendra.model.EntityConfiguration.ReadOnly] = impl
      .entityList()
      .asScala
      .map { item =>
        zio.aws.kendra.model.EntityConfiguration.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceRequest
  ): zio.aws.kendra.model.DisassociateEntitiesFromExperienceRequest.ReadOnly =
    new Wrapper(impl)
}
