package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  AccessControlConfigurationId,
  Blob,
  Title,
  DocumentId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Document(
    id: DocumentId,
    title: Optional[Title] = Optional.Absent,
    blob: Optional[Blob] = Optional.Absent,
    s3Path: Optional[zio.aws.kendra.model.S3Path] = Optional.Absent,
    attributes: Optional[Iterable[zio.aws.kendra.model.DocumentAttribute]] =
      Optional.Absent,
    accessControlList: Optional[Iterable[zio.aws.kendra.model.Principal]] =
      Optional.Absent,
    hierarchicalAccessControlList: Optional[
      Iterable[zio.aws.kendra.model.HierarchicalPrincipal]
    ] = Optional.Absent,
    contentType: Optional[zio.aws.kendra.model.ContentType] = Optional.Absent,
    accessControlConfigurationId: Optional[AccessControlConfigurationId] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.Document = {
    import Document.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Document
      .builder()
      .id(DocumentId.unwrap(id): java.lang.String)
      .optionallyWith(
        title.map(value => Title.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        blob.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.blob)
      .optionallyWith(s3Path.map(value => value.buildAwsValue()))(_.s3Path)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        accessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessControlList)
      .optionallyWith(
        hierarchicalAccessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hierarchicalAccessControlList)
      .optionallyWith(contentType.map(value => value.unwrap))(_.contentType)
      .optionallyWith(
        accessControlConfigurationId.map(value =>
          AccessControlConfigurationId.unwrap(value): java.lang.String
        )
      )(_.accessControlConfigurationId)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Document.ReadOnly =
    zio.aws.kendra.model.Document.wrap(buildAwsValue())
}
object Document {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Document] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Document =
      zio.aws.kendra.model.Document(
        id,
        title.map(value => value),
        blob.map(value => value),
        s3Path.map(value => value.asEditable),
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        accessControlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hierarchicalAccessControlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        contentType.map(value => value),
        accessControlConfigurationId.map(value => value)
      )
    def id: DocumentId
    def title: Optional[Title]
    def blob: Optional[Blob]
    def s3Path: Optional[zio.aws.kendra.model.S3Path.ReadOnly]
    def attributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]]
    def accessControlList
        : Optional[List[zio.aws.kendra.model.Principal.ReadOnly]]
    def hierarchicalAccessControlList
        : Optional[List[zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly]]
    def contentType: Optional[zio.aws.kendra.model.ContentType]
    def accessControlConfigurationId: Optional[AccessControlConfigurationId]
    def getId: ZIO[Any, Nothing, DocumentId] = ZIO.succeed(id)
    def getTitle: ZIO[Any, AwsError, Title] =
      AwsError.unwrapOptionField("title", title)
    def getBlob: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("blob", blob)
    def getS3Path: ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("s3Path", s3Path)
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getAccessControlList
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Principal.ReadOnly]] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getHierarchicalAccessControlList: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "hierarchicalAccessControlList",
      hierarchicalAccessControlList
    )
    def getContentType: ZIO[Any, AwsError, zio.aws.kendra.model.ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getAccessControlConfigurationId
        : ZIO[Any, AwsError, AccessControlConfigurationId] =
      AwsError.unwrapOptionField(
        "accessControlConfigurationId",
        accessControlConfigurationId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Document
  ) extends zio.aws.kendra.model.Document.ReadOnly {
    override val id: DocumentId =
      zio.aws.kendra.model.primitives.DocumentId(impl.id())
    override val title: Optional[Title] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.kendra.model.primitives.Title(value))
    override val blob: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.blob())
      .map(value =>
        zio.aws.kendra.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val s3Path: Optional[zio.aws.kendra.model.S3Path.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Path())
        .map(value => zio.aws.kendra.model.S3Path.wrap(value))
    override val attributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.DocumentAttribute.wrap(item)
          }.toList
        )
    override val accessControlList
        : Optional[List[zio.aws.kendra.model.Principal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Principal.wrap(item)
          }.toList
        )
    override val hierarchicalAccessControlList
        : Optional[List[zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchicalAccessControlList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.HierarchicalPrincipal.wrap(item)
          }.toList
        )
    override val contentType: Optional[zio.aws.kendra.model.ContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentType())
        .map(value => zio.aws.kendra.model.ContentType.wrap(value))
    override val accessControlConfigurationId
        : Optional[AccessControlConfigurationId] = zio.aws.core.internal
      .optionalFromNullable(impl.accessControlConfigurationId())
      .map(value =>
        zio.aws.kendra.model.primitives.AccessControlConfigurationId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Document
  ): zio.aws.kendra.model.Document.ReadOnly = new Wrapper(impl)
}
