package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentAttributeKey
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DocumentAttributeCondition(
    conditionDocumentAttributeKey: DocumentAttributeKey,
    operator: zio.aws.kendra.model.ConditionOperator,
    conditionOnValue: Optional[zio.aws.kendra.model.DocumentAttributeValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DocumentAttributeCondition = {
    import DocumentAttributeCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DocumentAttributeCondition
      .builder()
      .conditionDocumentAttributeKey(
        DocumentAttributeKey.unwrap(
          conditionDocumentAttributeKey
        ): java.lang.String
      )
      .operator(operator.unwrap)
      .optionallyWith(conditionOnValue.map(value => value.buildAwsValue()))(
        _.conditionOnValue
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly =
    zio.aws.kendra.model.DocumentAttributeCondition.wrap(buildAwsValue())
}
object DocumentAttributeCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DocumentAttributeCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DocumentAttributeCondition =
      zio.aws.kendra.model.DocumentAttributeCondition(
        conditionDocumentAttributeKey,
        operator,
        conditionOnValue.map(value => value.asEditable)
      )
    def conditionDocumentAttributeKey: DocumentAttributeKey
    def operator: zio.aws.kendra.model.ConditionOperator
    def conditionOnValue
        : Optional[zio.aws.kendra.model.DocumentAttributeValue.ReadOnly]
    def getConditionDocumentAttributeKey
        : ZIO[Any, Nothing, DocumentAttributeKey] =
      ZIO.succeed(conditionDocumentAttributeKey)
    def getOperator: ZIO[Any, Nothing, zio.aws.kendra.model.ConditionOperator] =
      ZIO.succeed(operator)
    def getConditionOnValue: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DocumentAttributeValue.ReadOnly
    ] = AwsError.unwrapOptionField("conditionOnValue", conditionOnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttributeCondition
  ) extends zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly {
    override val conditionDocumentAttributeKey: DocumentAttributeKey =
      zio.aws.kendra.model.primitives
        .DocumentAttributeKey(impl.conditionDocumentAttributeKey())
    override val operator: zio.aws.kendra.model.ConditionOperator =
      zio.aws.kendra.model.ConditionOperator.wrap(impl.operator())
    override val conditionOnValue
        : Optional[zio.aws.kendra.model.DocumentAttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionOnValue())
        .map(value => zio.aws.kendra.model.DocumentAttributeValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttributeCondition
  ): zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly = new Wrapper(
    impl
  )
}
