package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{Timestamp, DocumentAttributeStringValue}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DocumentAttributeValue(
    stringValue: Optional[DocumentAttributeStringValue] = Optional.Absent,
    stringListValue: Optional[Iterable[String]] = Optional.Absent,
    longValue: Optional[Long] = Optional.Absent,
    dateValue: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DocumentAttributeValue = {
    import DocumentAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DocumentAttributeValue
      .builder()
      .optionallyWith(
        stringValue.map(value =>
          DocumentAttributeStringValue.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .optionallyWith(
        stringListValue.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.stringListValue)
      .optionallyWith(longValue.map(value => value: java.lang.Long))(
        _.longValue
      )
      .optionallyWith(dateValue.map(value => Timestamp.unwrap(value): Instant))(
        _.dateValue
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DocumentAttributeValue.ReadOnly =
    zio.aws.kendra.model.DocumentAttributeValue.wrap(buildAwsValue())
}
object DocumentAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DocumentAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DocumentAttributeValue =
      zio.aws.kendra.model.DocumentAttributeValue(
        stringValue.map(value => value),
        stringListValue.map(value => value),
        longValue.map(value => value),
        dateValue.map(value => value)
      )
    def stringValue: Optional[DocumentAttributeStringValue]
    def stringListValue: Optional[List[String]]
    def longValue: Optional[Long]
    def dateValue: Optional[Timestamp]
    def getStringValue: ZIO[Any, AwsError, DocumentAttributeStringValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getStringListValue: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("stringListValue", stringListValue)
    def getLongValue: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("longValue", longValue)
    def getDateValue: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dateValue", dateValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttributeValue
  ) extends zio.aws.kendra.model.DocumentAttributeValue.ReadOnly {
    override val stringValue: Optional[DocumentAttributeStringValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringValue())
        .map(value =>
          zio.aws.kendra.model.primitives.DocumentAttributeStringValue(value)
        )
    override val stringListValue: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.stringListValue())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val longValue: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.longValue())
      .map(value => value: Long)
    override val dateValue: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dateValue())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttributeValue
  ): zio.aws.kendra.model.DocumentAttributeValue.ReadOnly = new Wrapper(impl)
}
