package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DocumentAttributeValueCountPair(
    documentAttributeValue: Optional[
      zio.aws.kendra.model.DocumentAttributeValue
    ] = Optional.Absent,
    count: Optional[Integer] = Optional.Absent,
    facetResults: Optional[Iterable[zio.aws.kendra.model.FacetResult]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair = {
    import DocumentAttributeValueCountPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair
      .builder()
      .optionallyWith(
        documentAttributeValue.map(value => value.buildAwsValue())
      )(_.documentAttributeValue)
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .optionallyWith(
        facetResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.facetResults)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DocumentAttributeValueCountPair.ReadOnly =
    zio.aws.kendra.model.DocumentAttributeValueCountPair.wrap(buildAwsValue())
}
object DocumentAttributeValueCountPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DocumentAttributeValueCountPair =
      zio.aws.kendra.model.DocumentAttributeValueCountPair(
        documentAttributeValue.map(value => value.asEditable),
        count.map(value => value),
        facetResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentAttributeValue
        : Optional[zio.aws.kendra.model.DocumentAttributeValue.ReadOnly]
    def count: Optional[Integer]
    def facetResults: Optional[List[zio.aws.kendra.model.FacetResult.ReadOnly]]
    def getDocumentAttributeValue: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DocumentAttributeValue.ReadOnly
    ] = AwsError.unwrapOptionField(
      "documentAttributeValue",
      documentAttributeValue
    )
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getFacetResults
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.FacetResult.ReadOnly]] =
      AwsError.unwrapOptionField("facetResults", facetResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair
  ) extends zio.aws.kendra.model.DocumentAttributeValueCountPair.ReadOnly {
    override val documentAttributeValue
        : Optional[zio.aws.kendra.model.DocumentAttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentAttributeValue())
        .map(value => zio.aws.kendra.model.DocumentAttributeValue.wrap(value))
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
    override val facetResults
        : Optional[List[zio.aws.kendra.model.FacetResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.facetResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.FacetResult.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair
  ): zio.aws.kendra.model.DocumentAttributeValueCountPair.ReadOnly =
    new Wrapper(impl)
}
