package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DocumentInfo(
    documentId: DocumentId,
    attributes: Optional[Iterable[zio.aws.kendra.model.DocumentAttribute]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DocumentInfo = {
    import DocumentInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DocumentInfo
      .builder()
      .documentId(DocumentId.unwrap(documentId): java.lang.String)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DocumentInfo.ReadOnly =
    zio.aws.kendra.model.DocumentInfo.wrap(buildAwsValue())
}
object DocumentInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DocumentInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DocumentInfo =
      zio.aws.kendra.model.DocumentInfo(
        documentId,
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentId: DocumentId
    def attributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]]
    def getDocumentId: ZIO[Any, Nothing, DocumentId] = ZIO.succeed(documentId)
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DocumentInfo
  ) extends zio.aws.kendra.model.DocumentInfo.ReadOnly {
    override val documentId: DocumentId =
      zio.aws.kendra.model.primitives.DocumentId(impl.documentId())
    override val attributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.DocumentAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DocumentInfo
  ): zio.aws.kendra.model.DocumentInfo.ReadOnly = new Wrapper(impl)
}
