package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentStatus {
  def unwrap: software.amazon.awssdk.services.kendra.model.DocumentStatus
}
object DocumentStatus {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.DocumentStatus
  ): zio.aws.kendra.model.DocumentStatus = value match {
    case software.amazon.awssdk.services.kendra.model.DocumentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.DocumentStatus.NOT_FOUND =>
      val r = NOT_FOUND
      r
    case software.amazon.awssdk.services.kendra.model.DocumentStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.kendra.model.DocumentStatus.INDEXED =>
      val r = INDEXED
      r
    case software.amazon.awssdk.services.kendra.model.DocumentStatus.UPDATED =>
      val r = UPDATED
      r
    case software.amazon.awssdk.services.kendra.model.DocumentStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.kendra.model.DocumentStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentStatus =
      software.amazon.awssdk.services.kendra.model.DocumentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_FOUND extends zio.aws.kendra.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentStatus =
      software.amazon.awssdk.services.kendra.model.DocumentStatus.NOT_FOUND
  }
  case object PROCESSING extends zio.aws.kendra.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentStatus =
      software.amazon.awssdk.services.kendra.model.DocumentStatus.PROCESSING
  }
  case object INDEXED extends zio.aws.kendra.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentStatus =
      software.amazon.awssdk.services.kendra.model.DocumentStatus.INDEXED
  }
  case object UPDATED extends zio.aws.kendra.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentStatus =
      software.amazon.awssdk.services.kendra.model.DocumentStatus.UPDATED
  }
  case object FAILED extends zio.aws.kendra.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentStatus =
      software.amazon.awssdk.services.kendra.model.DocumentStatus.FAILED
  }
  case object UPDATE_FAILED extends zio.aws.kendra.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentStatus =
      software.amazon.awssdk.services.kendra.model.DocumentStatus.UPDATE_FAILED
  }
}
