package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.S3ObjectKey
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DocumentsMetadataConfiguration(
    s3Prefix: Optional[S3ObjectKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DocumentsMetadataConfiguration = {
    import DocumentsMetadataConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DocumentsMetadataConfiguration
      .builder()
      .optionallyWith(
        s3Prefix.map(value => S3ObjectKey.unwrap(value): java.lang.String)
      )(_.s3Prefix)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DocumentsMetadataConfiguration.ReadOnly =
    zio.aws.kendra.model.DocumentsMetadataConfiguration.wrap(buildAwsValue())
}
object DocumentsMetadataConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DocumentsMetadataConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DocumentsMetadataConfiguration =
      zio.aws.kendra.model
        .DocumentsMetadataConfiguration(s3Prefix.map(value => value))
    def s3Prefix: Optional[S3ObjectKey]
    def getS3Prefix: ZIO[Any, AwsError, S3ObjectKey] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DocumentsMetadataConfiguration
  ) extends zio.aws.kendra.model.DocumentsMetadataConfiguration.ReadOnly {
    override val s3Prefix: Optional[S3ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Prefix())
      .map(value => zio.aws.kendra.model.primitives.S3ObjectKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DocumentsMetadataConfiguration
  ): zio.aws.kendra.model.DocumentsMetadataConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
