package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait EndpointType {
  def unwrap: software.amazon.awssdk.services.kendra.model.EndpointType
}
object EndpointType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.EndpointType
  ): zio.aws.kendra.model.EndpointType = value match {
    case software.amazon.awssdk.services.kendra.model.EndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.EndpointType.HOME =>
      val r = HOME
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.EndpointType =
      software.amazon.awssdk.services.kendra.model.EndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object HOME extends zio.aws.kendra.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.EndpointType =
      software.amazon.awssdk.services.kendra.model.EndpointType.HOME
  }
}
