package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.EntityId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EntityConfiguration(
    entityId: EntityId,
    entityType: zio.aws.kendra.model.EntityType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.EntityConfiguration = {
    import EntityConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.EntityConfiguration
      .builder()
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .entityType(entityType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.EntityConfiguration.ReadOnly =
    zio.aws.kendra.model.EntityConfiguration.wrap(buildAwsValue())
}
object EntityConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.EntityConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.EntityConfiguration =
      zio.aws.kendra.model.EntityConfiguration(entityId, entityType)
    def entityId: EntityId
    def entityType: zio.aws.kendra.model.EntityType
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getEntityType: ZIO[Any, Nothing, zio.aws.kendra.model.EntityType] =
      ZIO.succeed(entityType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.EntityConfiguration
  ) extends zio.aws.kendra.model.EntityConfiguration.ReadOnly {
    override val entityId: EntityId =
      zio.aws.kendra.model.primitives.EntityId(impl.entityId())
    override val entityType: zio.aws.kendra.model.EntityType =
      zio.aws.kendra.model.EntityType.wrap(impl.entityType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.EntityConfiguration
  ): zio.aws.kendra.model.EntityConfiguration.ReadOnly = new Wrapper(impl)
}
