package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait EntityType {
  def unwrap: software.amazon.awssdk.services.kendra.model.EntityType
}
object EntityType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.EntityType
  ): zio.aws.kendra.model.EntityType = value match {
    case software.amazon.awssdk.services.kendra.model.EntityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.EntityType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.kendra.model.EntityType.GROUP =>
      val r = GROUP
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.EntityType =
      software.amazon.awssdk.services.kendra.model.EntityType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.kendra.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.EntityType =
      software.amazon.awssdk.services.kendra.model.EntityType.USER
  }
  case object GROUP extends zio.aws.kendra.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.EntityType =
      software.amazon.awssdk.services.kendra.model.EntityType.GROUP
  }
}
