package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.kendra.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.ErrorCode
  ): zio.aws.kendra.model.ErrorCode = value match {
    case software.amazon.awssdk.services.kendra.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.ErrorCode.INTERNAL_ERROR =>
      val r = InternalError
      r
    case software.amazon.awssdk.services.kendra.model.ErrorCode.INVALID_REQUEST =>
      val r = InvalidRequest
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ErrorCode =
      software.amazon.awssdk.services.kendra.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object InternalError extends zio.aws.kendra.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ErrorCode =
      software.amazon.awssdk.services.kendra.model.ErrorCode.INTERNAL_ERROR
  }
  case object InvalidRequest extends zio.aws.kendra.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ErrorCode =
      software.amazon.awssdk.services.kendra.model.ErrorCode.INVALID_REQUEST
  }
}
