package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExpandConfiguration(
    maxResultItemsToExpand: Optional[Integer] = Optional.Absent,
    maxExpandedResultsPerItem: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ExpandConfiguration = {
    import ExpandConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ExpandConfiguration
      .builder()
      .optionallyWith(
        maxResultItemsToExpand.map(value => value: java.lang.Integer)
      )(_.maxResultItemsToExpand)
      .optionallyWith(
        maxExpandedResultsPerItem.map(value => value: java.lang.Integer)
      )(_.maxExpandedResultsPerItem)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ExpandConfiguration.ReadOnly =
    zio.aws.kendra.model.ExpandConfiguration.wrap(buildAwsValue())
}
object ExpandConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ExpandConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ExpandConfiguration =
      zio.aws.kendra.model.ExpandConfiguration(
        maxResultItemsToExpand.map(value => value),
        maxExpandedResultsPerItem.map(value => value)
      )
    def maxResultItemsToExpand: Optional[Integer]
    def maxExpandedResultsPerItem: Optional[Integer]
    def getMaxResultItemsToExpand: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxResultItemsToExpand", maxResultItemsToExpand)
    def getMaxExpandedResultsPerItem: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxExpandedResultsPerItem", maxExpandedResultsPerItem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ExpandConfiguration
  ) extends zio.aws.kendra.model.ExpandConfiguration.ReadOnly {
    override val maxResultItemsToExpand: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResultItemsToExpand())
        .map(value => value: Integer)
    override val maxExpandedResultsPerItem: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxExpandedResultsPerItem())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ExpandConfiguration
  ): zio.aws.kendra.model.ExpandConfiguration.ReadOnly = new Wrapper(impl)
}
