package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Url, DocumentId, ResultId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExpandedResultItem(
    id: Optional[ResultId] = Optional.Absent,
    documentId: Optional[DocumentId] = Optional.Absent,
    documentTitle: Optional[zio.aws.kendra.model.TextWithHighlights] =
      Optional.Absent,
    documentExcerpt: Optional[zio.aws.kendra.model.TextWithHighlights] =
      Optional.Absent,
    documentURI: Optional[Url] = Optional.Absent,
    documentAttributes: Optional[
      Iterable[zio.aws.kendra.model.DocumentAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ExpandedResultItem = {
    import ExpandedResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ExpandedResultItem
      .builder()
      .optionallyWith(
        id.map(value => ResultId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        documentId.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.documentId)
      .optionallyWith(documentTitle.map(value => value.buildAwsValue()))(
        _.documentTitle
      )
      .optionallyWith(documentExcerpt.map(value => value.buildAwsValue()))(
        _.documentExcerpt
      )
      .optionallyWith(
        documentURI.map(value => Url.unwrap(value): java.lang.String)
      )(_.documentURI)
      .optionallyWith(
        documentAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentAttributes)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ExpandedResultItem.ReadOnly =
    zio.aws.kendra.model.ExpandedResultItem.wrap(buildAwsValue())
}
object ExpandedResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ExpandedResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ExpandedResultItem =
      zio.aws.kendra.model.ExpandedResultItem(
        id.map(value => value),
        documentId.map(value => value),
        documentTitle.map(value => value.asEditable),
        documentExcerpt.map(value => value.asEditable),
        documentURI.map(value => value),
        documentAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Optional[ResultId]
    def documentId: Optional[DocumentId]
    def documentTitle
        : Optional[zio.aws.kendra.model.TextWithHighlights.ReadOnly]
    def documentExcerpt
        : Optional[zio.aws.kendra.model.TextWithHighlights.ReadOnly]
    def documentURI: Optional[Url]
    def documentAttributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]]
    def getId: ZIO[Any, AwsError, ResultId] =
      AwsError.unwrapOptionField("id", id)
    def getDocumentId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("documentId", documentId)
    def getDocumentTitle
        : ZIO[Any, AwsError, zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      AwsError.unwrapOptionField("documentTitle", documentTitle)
    def getDocumentExcerpt
        : ZIO[Any, AwsError, zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      AwsError.unwrapOptionField("documentExcerpt", documentExcerpt)
    def getDocumentURI: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("documentURI", documentURI)
    def getDocumentAttributes: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("documentAttributes", documentAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ExpandedResultItem
  ) extends zio.aws.kendra.model.ExpandedResultItem.ReadOnly {
    override val id: Optional[ResultId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ResultId(value))
    override val documentId: Optional[DocumentId] = zio.aws.core.internal
      .optionalFromNullable(impl.documentId())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
    override val documentTitle
        : Optional[zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentTitle())
        .map(value => zio.aws.kendra.model.TextWithHighlights.wrap(value))
    override val documentExcerpt
        : Optional[zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentExcerpt())
        .map(value => zio.aws.kendra.model.TextWithHighlights.wrap(value))
    override val documentURI: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.documentURI())
      .map(value => zio.aws.kendra.model.primitives.Url(value))
    override val documentAttributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.DocumentAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ExpandedResultItem
  ): zio.aws.kendra.model.ExpandedResultItem.ReadOnly = new Wrapper(impl)
}
