package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait ExperienceStatus {
  def unwrap: software.amazon.awssdk.services.kendra.model.ExperienceStatus
}
object ExperienceStatus {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.ExperienceStatus
  ): zio.aws.kendra.model.ExperienceStatus = value match {
    case software.amazon.awssdk.services.kendra.model.ExperienceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.ExperienceStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kendra.model.ExperienceStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.kendra.model.ExperienceStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kendra.model.ExperienceStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.ExperienceStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ExperienceStatus =
      software.amazon.awssdk.services.kendra.model.ExperienceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.kendra.model.ExperienceStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ExperienceStatus =
      software.amazon.awssdk.services.kendra.model.ExperienceStatus.CREATING
  }
  case object ACTIVE extends zio.aws.kendra.model.ExperienceStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ExperienceStatus =
      software.amazon.awssdk.services.kendra.model.ExperienceStatus.ACTIVE
  }
  case object DELETING extends zio.aws.kendra.model.ExperienceStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ExperienceStatus =
      software.amazon.awssdk.services.kendra.model.ExperienceStatus.DELETING
  }
  case object FAILED extends zio.aws.kendra.model.ExperienceStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ExperienceStatus =
      software.amazon.awssdk.services.kendra.model.ExperienceStatus.FAILED
  }
}
