package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  TopDocumentAttributeValueCountPairsSize,
  DocumentAttributeKey
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Facet(
    documentAttributeKey: Optional[DocumentAttributeKey] = Optional.Absent,
    facets: Optional[Iterable[zio.aws.kendra.model.Facet]] = Optional.Absent,
    maxResults: Optional[TopDocumentAttributeValueCountPairsSize] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.Facet = {
    import Facet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Facet
      .builder()
      .optionallyWith(
        documentAttributeKey.map(value =>
          DocumentAttributeKey.unwrap(value): java.lang.String
        )
      )(_.documentAttributeKey)
      .optionallyWith(
        facets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.facets)
      .optionallyWith(
        maxResults.map(value =>
          TopDocumentAttributeValueCountPairsSize.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Facet.ReadOnly =
    zio.aws.kendra.model.Facet.wrap(buildAwsValue())
}
object Facet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Facet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Facet = zio.aws.kendra.model.Facet(
      documentAttributeKey.map(value => value),
      facets.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      maxResults.map(value => value)
    )
    def documentAttributeKey: Optional[DocumentAttributeKey]
    def facets: Optional[List[zio.aws.kendra.model.Facet.ReadOnly]]
    def maxResults: Optional[TopDocumentAttributeValueCountPairsSize]
    def getDocumentAttributeKey: ZIO[Any, AwsError, DocumentAttributeKey] =
      AwsError.unwrapOptionField("documentAttributeKey", documentAttributeKey)
    def getFacets
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Facet.ReadOnly]] =
      AwsError.unwrapOptionField("facets", facets)
    def getMaxResults
        : ZIO[Any, AwsError, TopDocumentAttributeValueCountPairsSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Facet
  ) extends zio.aws.kendra.model.Facet.ReadOnly {
    override val documentAttributeKey: Optional[DocumentAttributeKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentAttributeKey())
        .map(value =>
          zio.aws.kendra.model.primitives.DocumentAttributeKey(value)
        )
    override val facets: Optional[List[zio.aws.kendra.model.Facet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.facets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Facet.wrap(item)
          }.toList
        )
    override val maxResults: Optional[TopDocumentAttributeValueCountPairsSize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kendra.model.primitives
            .TopDocumentAttributeValueCountPairsSize(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Facet
  ): zio.aws.kendra.model.Facet.ReadOnly = new Wrapper(impl)
}
