package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait FaqFileFormat {
  def unwrap: software.amazon.awssdk.services.kendra.model.FaqFileFormat
}
object FaqFileFormat {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.FaqFileFormat
  ): zio.aws.kendra.model.FaqFileFormat = value match {
    case software.amazon.awssdk.services.kendra.model.FaqFileFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.FaqFileFormat.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.kendra.model.FaqFileFormat.CSV_WITH_HEADER =>
      val r = CSV_WITH_HEADER
      r
    case software.amazon.awssdk.services.kendra.model.FaqFileFormat.JSON =>
      val r = JSON
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.FaqFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.FaqFileFormat =
      software.amazon.awssdk.services.kendra.model.FaqFileFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.kendra.model.FaqFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.FaqFileFormat =
      software.amazon.awssdk.services.kendra.model.FaqFileFormat.CSV
  }
  case object CSV_WITH_HEADER extends zio.aws.kendra.model.FaqFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.FaqFileFormat =
      software.amazon.awssdk.services.kendra.model.FaqFileFormat.CSV_WITH_HEADER
  }
  case object JSON extends zio.aws.kendra.model.FaqFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.FaqFileFormat =
      software.amazon.awssdk.services.kendra.model.FaqFileFormat.JSON
  }
}
