package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{LanguageCode, Timestamp, FaqName, FaqId}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class FaqSummary(
    id: Optional[FaqId] = Optional.Absent,
    name: Optional[FaqName] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.FaqStatus] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    fileFormat: Optional[zio.aws.kendra.model.FaqFileFormat] = Optional.Absent,
    languageCode: Optional[LanguageCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.FaqSummary = {
    import FaqSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.FaqSummary
      .builder()
      .optionallyWith(id.map(value => FaqId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => FaqName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.FaqSummary.ReadOnly =
    zio.aws.kendra.model.FaqSummary.wrap(buildAwsValue())
}
object FaqSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.FaqSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.FaqSummary =
      zio.aws.kendra.model.FaqSummary(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        fileFormat.map(value => value),
        languageCode.map(value => value)
      )
    def id: Optional[FaqId]
    def name: Optional[FaqName]
    def status: Optional[zio.aws.kendra.model.FaqStatus]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def fileFormat: Optional[zio.aws.kendra.model.FaqFileFormat]
    def languageCode: Optional[LanguageCode]
    def getId: ZIO[Any, AwsError, FaqId] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, FaqName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.FaqStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getFileFormat: ZIO[Any, AwsError, zio.aws.kendra.model.FaqFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.FaqSummary
  ) extends zio.aws.kendra.model.FaqSummary.ReadOnly {
    override val id: Optional[FaqId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.FaqId(value))
    override val name: Optional[FaqName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.FaqName(value))
    override val status: Optional[zio.aws.kendra.model.FaqStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.FaqStatus.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val fileFormat: Optional[zio.aws.kendra.model.FaqFileFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileFormat())
        .map(value => zio.aws.kendra.model.FaqFileFormat.wrap(value))
    override val languageCode: Optional[LanguageCode] = zio.aws.core.internal
      .optionalFromNullable(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.FaqSummary
  ): zio.aws.kendra.model.FaqSummary.ReadOnly = new Wrapper(impl)
}
