package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FeaturedDocument(id: Optional[DocumentId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.FeaturedDocument = {
    import FeaturedDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.FeaturedDocument
      .builder()
      .optionallyWith(
        id.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.FeaturedDocument.ReadOnly =
    zio.aws.kendra.model.FeaturedDocument.wrap(buildAwsValue())
}
object FeaturedDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.FeaturedDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.FeaturedDocument =
      zio.aws.kendra.model.FeaturedDocument(id.map(value => value))
    def id: Optional[DocumentId]
    def getId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.FeaturedDocument
  ) extends zio.aws.kendra.model.FeaturedDocument.ReadOnly {
    override val id: Optional[DocumentId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.FeaturedDocument
  ): zio.aws.kendra.model.FeaturedDocument.ReadOnly = new Wrapper(impl)
}
