package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FeaturedDocumentMissing(
    id: Optional[DocumentId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.FeaturedDocumentMissing = {
    import FeaturedDocumentMissing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.FeaturedDocumentMissing
      .builder()
      .optionallyWith(
        id.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.FeaturedDocumentMissing.ReadOnly =
    zio.aws.kendra.model.FeaturedDocumentMissing.wrap(buildAwsValue())
}
object FeaturedDocumentMissing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.FeaturedDocumentMissing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.FeaturedDocumentMissing =
      zio.aws.kendra.model.FeaturedDocumentMissing(id.map(value => value))
    def id: Optional[DocumentId]
    def getId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.FeaturedDocumentMissing
  ) extends zio.aws.kendra.model.FeaturedDocumentMissing.ReadOnly {
    override val id: Optional[DocumentId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.FeaturedDocumentMissing
  ): zio.aws.kendra.model.FeaturedDocumentMissing.ReadOnly = new Wrapper(impl)
}
