package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Url, DocumentId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FeaturedDocumentWithMetadata(
    id: Optional[DocumentId] = Optional.Absent,
    title: Optional[String] = Optional.Absent,
    uri: Optional[Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.FeaturedDocumentWithMetadata = {
    import FeaturedDocumentWithMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.FeaturedDocumentWithMetadata
      .builder()
      .optionallyWith(
        id.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(uri.map(value => Url.unwrap(value): java.lang.String))(
        _.uri
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.FeaturedDocumentWithMetadata.ReadOnly =
    zio.aws.kendra.model.FeaturedDocumentWithMetadata.wrap(buildAwsValue())
}
object FeaturedDocumentWithMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.FeaturedDocumentWithMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.FeaturedDocumentWithMetadata =
      zio.aws.kendra.model.FeaturedDocumentWithMetadata(
        id.map(value => value),
        title.map(value => value),
        uri.map(value => value)
      )
    def id: Optional[DocumentId]
    def title: Optional[String]
    def uri: Optional[Url]
    def getId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("id", id)
    def getTitle: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("title", title)
    def getUri: ZIO[Any, AwsError, Url] = AwsError.unwrapOptionField("uri", uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.FeaturedDocumentWithMetadata
  ) extends zio.aws.kendra.model.FeaturedDocumentWithMetadata.ReadOnly {
    override val id: Optional[DocumentId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
    override val title: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: String)
    override val uri: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => zio.aws.kendra.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.FeaturedDocumentWithMetadata
  ): zio.aws.kendra.model.FeaturedDocumentWithMetadata.ReadOnly = new Wrapper(
    impl
  )
}
