package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  QueryText,
  FeaturedResultsSetDescription,
  FeaturedResultsSetName,
  FeaturedResultsSetId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FeaturedResultsSet(
    featuredResultsSetId: Optional[FeaturedResultsSetId] = Optional.Absent,
    featuredResultsSetName: Optional[FeaturedResultsSetName] = Optional.Absent,
    description: Optional[FeaturedResultsSetDescription] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.FeaturedResultsSetStatus] =
      Optional.Absent,
    queryTexts: Optional[Iterable[QueryText]] = Optional.Absent,
    featuredDocuments: Optional[
      Iterable[zio.aws.kendra.model.FeaturedDocument]
    ] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Long] = Optional.Absent,
    creationTimestamp: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.FeaturedResultsSet = {
    import FeaturedResultsSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.FeaturedResultsSet
      .builder()
      .optionallyWith(
        featuredResultsSetId.map(value =>
          FeaturedResultsSetId.unwrap(value): java.lang.String
        )
      )(_.featuredResultsSetId)
      .optionallyWith(
        featuredResultsSetName.map(value =>
          FeaturedResultsSetName.unwrap(value): java.lang.String
        )
      )(_.featuredResultsSetName)
      .optionallyWith(
        description.map(value =>
          FeaturedResultsSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        queryTexts.map(value =>
          value.map { item =>
            QueryText.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queryTexts)
      .optionallyWith(
        featuredDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.featuredDocuments)
      .optionallyWith(lastUpdatedTimestamp.map(value => value: java.lang.Long))(
        _.lastUpdatedTimestamp
      )
      .optionallyWith(creationTimestamp.map(value => value: java.lang.Long))(
        _.creationTimestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.FeaturedResultsSet.ReadOnly =
    zio.aws.kendra.model.FeaturedResultsSet.wrap(buildAwsValue())
}
object FeaturedResultsSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.FeaturedResultsSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.FeaturedResultsSet =
      zio.aws.kendra.model.FeaturedResultsSet(
        featuredResultsSetId.map(value => value),
        featuredResultsSetName.map(value => value),
        description.map(value => value),
        status.map(value => value),
        queryTexts.map(value => value),
        featuredDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastUpdatedTimestamp.map(value => value),
        creationTimestamp.map(value => value)
      )
    def featuredResultsSetId: Optional[FeaturedResultsSetId]
    def featuredResultsSetName: Optional[FeaturedResultsSetName]
    def description: Optional[FeaturedResultsSetDescription]
    def status: Optional[zio.aws.kendra.model.FeaturedResultsSetStatus]
    def queryTexts: Optional[List[QueryText]]
    def featuredDocuments
        : Optional[List[zio.aws.kendra.model.FeaturedDocument.ReadOnly]]
    def lastUpdatedTimestamp: Optional[Long]
    def creationTimestamp: Optional[Long]
    def getFeaturedResultsSetId: ZIO[Any, AwsError, FeaturedResultsSetId] =
      AwsError.unwrapOptionField("featuredResultsSetId", featuredResultsSetId)
    def getFeaturedResultsSetName: ZIO[Any, AwsError, FeaturedResultsSetName] =
      AwsError.unwrapOptionField(
        "featuredResultsSetName",
        featuredResultsSetName
      )
    def getDescription: ZIO[Any, AwsError, FeaturedResultsSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.kendra.model.FeaturedResultsSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getQueryTexts: ZIO[Any, AwsError, List[QueryText]] =
      AwsError.unwrapOptionField("queryTexts", queryTexts)
    def getFeaturedDocuments: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.FeaturedDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("featuredDocuments", featuredDocuments)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getCreationTimestamp: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.FeaturedResultsSet
  ) extends zio.aws.kendra.model.FeaturedResultsSet.ReadOnly {
    override val featuredResultsSetId: Optional[FeaturedResultsSetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuredResultsSetId())
        .map(value =>
          zio.aws.kendra.model.primitives.FeaturedResultsSetId(value)
        )
    override val featuredResultsSetName: Optional[FeaturedResultsSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuredResultsSetName())
        .map(value =>
          zio.aws.kendra.model.primitives.FeaturedResultsSetName(value)
        )
    override val description: Optional[FeaturedResultsSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.kendra.model.primitives.FeaturedResultsSetDescription(value)
        )
    override val status
        : Optional[zio.aws.kendra.model.FeaturedResultsSetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.FeaturedResultsSetStatus.wrap(value))
    override val queryTexts: Optional[List[QueryText]] = zio.aws.core.internal
      .optionalFromNullable(impl.queryTexts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives.QueryText(item)
        }.toList
      )
    override val featuredDocuments
        : Optional[List[zio.aws.kendra.model.FeaturedDocument.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuredDocuments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.FeaturedDocument.wrap(item)
          }.toList
        )
    override val lastUpdatedTimestamp: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTimestamp())
      .map(value => value: Long)
    override val creationTimestamp: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.FeaturedResultsSet
  ): zio.aws.kendra.model.FeaturedResultsSet.ReadOnly = new Wrapper(impl)
}
