package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  FeaturedResultsSetName,
  FeaturedResultsSetId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FeaturedResultsSetSummary(
    featuredResultsSetId: Optional[FeaturedResultsSetId] = Optional.Absent,
    featuredResultsSetName: Optional[FeaturedResultsSetName] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.FeaturedResultsSetStatus] =
      Optional.Absent,
    lastUpdatedTimestamp: Optional[Long] = Optional.Absent,
    creationTimestamp: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.FeaturedResultsSetSummary = {
    import FeaturedResultsSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.FeaturedResultsSetSummary
      .builder()
      .optionallyWith(
        featuredResultsSetId.map(value =>
          FeaturedResultsSetId.unwrap(value): java.lang.String
        )
      )(_.featuredResultsSetId)
      .optionallyWith(
        featuredResultsSetName.map(value =>
          FeaturedResultsSetName.unwrap(value): java.lang.String
        )
      )(_.featuredResultsSetName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(lastUpdatedTimestamp.map(value => value: java.lang.Long))(
        _.lastUpdatedTimestamp
      )
      .optionallyWith(creationTimestamp.map(value => value: java.lang.Long))(
        _.creationTimestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.FeaturedResultsSetSummary.ReadOnly =
    zio.aws.kendra.model.FeaturedResultsSetSummary.wrap(buildAwsValue())
}
object FeaturedResultsSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.FeaturedResultsSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.FeaturedResultsSetSummary =
      zio.aws.kendra.model.FeaturedResultsSetSummary(
        featuredResultsSetId.map(value => value),
        featuredResultsSetName.map(value => value),
        status.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        creationTimestamp.map(value => value)
      )
    def featuredResultsSetId: Optional[FeaturedResultsSetId]
    def featuredResultsSetName: Optional[FeaturedResultsSetName]
    def status: Optional[zio.aws.kendra.model.FeaturedResultsSetStatus]
    def lastUpdatedTimestamp: Optional[Long]
    def creationTimestamp: Optional[Long]
    def getFeaturedResultsSetId: ZIO[Any, AwsError, FeaturedResultsSetId] =
      AwsError.unwrapOptionField("featuredResultsSetId", featuredResultsSetId)
    def getFeaturedResultsSetName: ZIO[Any, AwsError, FeaturedResultsSetName] =
      AwsError.unwrapOptionField(
        "featuredResultsSetName",
        featuredResultsSetName
      )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.kendra.model.FeaturedResultsSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getCreationTimestamp: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.FeaturedResultsSetSummary
  ) extends zio.aws.kendra.model.FeaturedResultsSetSummary.ReadOnly {
    override val featuredResultsSetId: Optional[FeaturedResultsSetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuredResultsSetId())
        .map(value =>
          zio.aws.kendra.model.primitives.FeaturedResultsSetId(value)
        )
    override val featuredResultsSetName: Optional[FeaturedResultsSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuredResultsSetName())
        .map(value =>
          zio.aws.kendra.model.primitives.FeaturedResultsSetName(value)
        )
    override val status
        : Optional[zio.aws.kendra.model.FeaturedResultsSetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.FeaturedResultsSetStatus.wrap(value))
    override val lastUpdatedTimestamp: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTimestamp())
      .map(value => value: Long)
    override val creationTimestamp: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.FeaturedResultsSetSummary
  ): zio.aws.kendra.model.FeaturedResultsSetSummary.ReadOnly = new Wrapper(impl)
}
