package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  SecretArn,
  FileSystemId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FsxConfiguration(
    fileSystemId: FileSystemId,
    fileSystemType: zio.aws.kendra.model.FsxFileSystemType,
    vpcConfiguration: zio.aws.kendra.model.DataSourceVpcConfiguration,
    secretArn: Optional[SecretArn] = Optional.Absent,
    inclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    exclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    fieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.FsxConfiguration = {
    import FsxConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.FsxConfiguration
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .fileSystemType(fileSystemType.unwrap)
      .vpcConfiguration(vpcConfiguration.buildAwsValue())
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.FsxConfiguration.ReadOnly =
    zio.aws.kendra.model.FsxConfiguration.wrap(buildAwsValue())
}
object FsxConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.FsxConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.FsxConfiguration =
      zio.aws.kendra.model.FsxConfiguration(
        fileSystemId,
        fileSystemType,
        vpcConfiguration.asEditable,
        secretArn.map(value => value),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fileSystemId: FileSystemId
    def fileSystemType: zio.aws.kendra.model.FsxFileSystemType
    def vpcConfiguration
        : zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    def secretArn: Optional[SecretArn]
    def inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getFileSystemType
        : ZIO[Any, Nothing, zio.aws.kendra.model.FsxFileSystemType] =
      ZIO.succeed(fileSystemType)
    def getVpcConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = ZIO.succeed(vpcConfiguration)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.FsxConfiguration
  ) extends zio.aws.kendra.model.FsxConfiguration.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.kendra.model.primitives.FileSystemId(impl.fileSystemId())
    override val fileSystemType: zio.aws.kendra.model.FsxFileSystemType =
      zio.aws.kendra.model.FsxFileSystemType.wrap(impl.fileSystemType())
    override val vpcConfiguration
        : zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly =
      zio.aws.kendra.model.DataSourceVpcConfiguration
        .wrap(impl.vpcConfiguration())
    override val secretArn: Optional[SecretArn] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => zio.aws.kendra.model.primitives.SecretArn(value))
    override val inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.FsxConfiguration
  ): zio.aws.kendra.model.FsxConfiguration.ReadOnly = new Wrapper(impl)
}
