package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Integer, SuggestionQueryText, IndexId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetQuerySuggestionsRequest(
    indexId: IndexId,
    queryText: SuggestionQueryText,
    maxSuggestionsCount: Optional[Integer] = Optional.Absent,
    suggestionTypes: Optional[Iterable[zio.aws.kendra.model.SuggestionType]] =
      Optional.Absent,
    attributeSuggestionsConfig: Optional[
      zio.aws.kendra.model.AttributeSuggestionsGetConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest = {
    import GetQuerySuggestionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .queryText(SuggestionQueryText.unwrap(queryText): java.lang.String)
      .optionallyWith(
        maxSuggestionsCount.map(value => value: java.lang.Integer)
      )(_.maxSuggestionsCount)
      .optionallyWith(
        suggestionTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.suggestionTypesWithStrings)
      .optionallyWith(
        attributeSuggestionsConfig.map(value => value.buildAwsValue())
      )(_.attributeSuggestionsConfig)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GetQuerySuggestionsRequest.ReadOnly =
    zio.aws.kendra.model.GetQuerySuggestionsRequest.wrap(buildAwsValue())
}
object GetQuerySuggestionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GetQuerySuggestionsRequest =
      zio.aws.kendra.model.GetQuerySuggestionsRequest(
        indexId,
        queryText,
        maxSuggestionsCount.map(value => value),
        suggestionTypes.map(value => value),
        attributeSuggestionsConfig.map(value => value.asEditable)
      )
    def indexId: IndexId
    def queryText: SuggestionQueryText
    def maxSuggestionsCount: Optional[Integer]
    def suggestionTypes: Optional[List[zio.aws.kendra.model.SuggestionType]]
    def attributeSuggestionsConfig
        : Optional[zio.aws.kendra.model.AttributeSuggestionsGetConfig.ReadOnly]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getQueryText: ZIO[Any, Nothing, SuggestionQueryText] =
      ZIO.succeed(queryText)
    def getMaxSuggestionsCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxSuggestionsCount", maxSuggestionsCount)
    def getSuggestionTypes
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.SuggestionType]] =
      AwsError.unwrapOptionField("suggestionTypes", suggestionTypes)
    def getAttributeSuggestionsConfig: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.AttributeSuggestionsGetConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "attributeSuggestionsConfig",
      attributeSuggestionsConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest
  ) extends zio.aws.kendra.model.GetQuerySuggestionsRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val queryText: SuggestionQueryText =
      zio.aws.kendra.model.primitives.SuggestionQueryText(impl.queryText())
    override val maxSuggestionsCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSuggestionsCount())
      .map(value => value: Integer)
    override val suggestionTypes
        : Optional[List[zio.aws.kendra.model.SuggestionType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suggestionTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.SuggestionType.wrap(item)
          }.toList
        )
    override val attributeSuggestionsConfig: Optional[
      zio.aws.kendra.model.AttributeSuggestionsGetConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeSuggestionsConfig())
      .map(value =>
        zio.aws.kendra.model.AttributeSuggestionsGetConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest
  ): zio.aws.kendra.model.GetQuerySuggestionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
