package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSnapshotsResponse(
    snapShotTimeFilter: Optional[zio.aws.kendra.model.TimeRange] =
      Optional.Absent,
    snapshotsDataHeader: Optional[Iterable[String]] = Optional.Absent,
    snapshotsData: Optional[Iterable[Iterable[String]]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse = {
    import GetSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse
      .builder()
      .optionallyWith(snapShotTimeFilter.map(value => value.buildAwsValue()))(
        _.snapShotTimeFilter
      )
      .optionallyWith(
        snapshotsDataHeader.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotsDataHeader)
      .optionallyWith(
        snapshotsData.map(value =>
          value.map { item =>
            item.map { item =>
              item: java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.snapshotsData)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GetSnapshotsResponse.ReadOnly =
    zio.aws.kendra.model.GetSnapshotsResponse.wrap(buildAwsValue())
}
object GetSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GetSnapshotsResponse =
      zio.aws.kendra.model.GetSnapshotsResponse(
        snapShotTimeFilter.map(value => value.asEditable),
        snapshotsDataHeader.map(value => value),
        snapshotsData.map(value => value),
        nextToken.map(value => value)
      )
    def snapShotTimeFilter: Optional[zio.aws.kendra.model.TimeRange.ReadOnly]
    def snapshotsDataHeader: Optional[List[String]]
    def snapshotsData: Optional[List[List[String]]]
    def nextToken: Optional[NextToken]
    def getSnapShotTimeFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.TimeRange.ReadOnly] =
      AwsError.unwrapOptionField("snapShotTimeFilter", snapShotTimeFilter)
    def getSnapshotsDataHeader: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("snapshotsDataHeader", snapshotsDataHeader)
    def getSnapshotsData: ZIO[Any, AwsError, List[List[String]]] =
      AwsError.unwrapOptionField("snapshotsData", snapshotsData)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse
  ) extends zio.aws.kendra.model.GetSnapshotsResponse.ReadOnly {
    override val snapShotTimeFilter
        : Optional[zio.aws.kendra.model.TimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapShotTimeFilter())
        .map(value => zio.aws.kendra.model.TimeRange.wrap(value))
    override val snapshotsDataHeader: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotsDataHeader())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val snapshotsData: Optional[List[List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotsData())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              item: String
            }.toList
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse
  ): zio.aws.kendra.model.GetSnapshotsResponse.ReadOnly = new Wrapper(impl)
}
