package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{RepositoryName, SecretArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GitHubConfiguration(
    saaSConfiguration: Optional[zio.aws.kendra.model.SaaSConfiguration] =
      Optional.Absent,
    onPremiseConfiguration: Optional[
      zio.aws.kendra.model.OnPremiseConfiguration
    ] = Optional.Absent,
    `type`: Optional[zio.aws.kendra.model.Type] = Optional.Absent,
    secretArn: SecretArn,
    useChangeLog: Optional[Boolean] = Optional.Absent,
    gitHubDocumentCrawlProperties: Optional[
      zio.aws.kendra.model.GitHubDocumentCrawlProperties
    ] = Optional.Absent,
    repositoryFilter: Optional[Iterable[RepositoryName]] = Optional.Absent,
    inclusionFolderNamePatterns: Optional[Iterable[String]] = Optional.Absent,
    inclusionFileTypePatterns: Optional[Iterable[String]] = Optional.Absent,
    inclusionFileNamePatterns: Optional[Iterable[String]] = Optional.Absent,
    exclusionFolderNamePatterns: Optional[Iterable[String]] = Optional.Absent,
    exclusionFileTypePatterns: Optional[Iterable[String]] = Optional.Absent,
    exclusionFileNamePatterns: Optional[Iterable[String]] = Optional.Absent,
    vpcConfiguration: Optional[
      zio.aws.kendra.model.DataSourceVpcConfiguration
    ] = Optional.Absent,
    gitHubRepositoryConfigurationFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    gitHubCommitConfigurationFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    gitHubIssueDocumentConfigurationFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    gitHubIssueCommentConfigurationFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    gitHubIssueAttachmentConfigurationFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    gitHubPullRequestCommentConfigurationFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    gitHubPullRequestDocumentConfigurationFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    gitHubPullRequestDocumentAttachmentConfigurationFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GitHubConfiguration = {
    import GitHubConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GitHubConfiguration
      .builder()
      .optionallyWith(saaSConfiguration.map(value => value.buildAwsValue()))(
        _.saaSConfiguration
      )
      .optionallyWith(
        onPremiseConfiguration.map(value => value.buildAwsValue())
      )(_.onPremiseConfiguration)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .optionallyWith(useChangeLog.map(value => value: java.lang.Boolean))(
        _.useChangeLog
      )
      .optionallyWith(
        gitHubDocumentCrawlProperties.map(value => value.buildAwsValue())
      )(_.gitHubDocumentCrawlProperties)
      .optionallyWith(
        repositoryFilter.map(value =>
          value.map { item =>
            RepositoryName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.repositoryFilter)
      .optionallyWith(
        inclusionFolderNamePatterns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionFolderNamePatterns)
      .optionallyWith(
        inclusionFileTypePatterns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionFileTypePatterns)
      .optionallyWith(
        inclusionFileNamePatterns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionFileNamePatterns)
      .optionallyWith(
        exclusionFolderNamePatterns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionFolderNamePatterns)
      .optionallyWith(
        exclusionFileTypePatterns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionFileTypePatterns)
      .optionallyWith(
        exclusionFileNamePatterns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionFileNamePatterns)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        gitHubRepositoryConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gitHubRepositoryConfigurationFieldMappings)
      .optionallyWith(
        gitHubCommitConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gitHubCommitConfigurationFieldMappings)
      .optionallyWith(
        gitHubIssueDocumentConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gitHubIssueDocumentConfigurationFieldMappings)
      .optionallyWith(
        gitHubIssueCommentConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gitHubIssueCommentConfigurationFieldMappings)
      .optionallyWith(
        gitHubIssueAttachmentConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gitHubIssueAttachmentConfigurationFieldMappings)
      .optionallyWith(
        gitHubPullRequestCommentConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gitHubPullRequestCommentConfigurationFieldMappings)
      .optionallyWith(
        gitHubPullRequestDocumentConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gitHubPullRequestDocumentConfigurationFieldMappings)
      .optionallyWith(
        gitHubPullRequestDocumentAttachmentConfigurationFieldMappings.map(
          value =>
            value.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
        )
      )(_.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GitHubConfiguration.ReadOnly =
    zio.aws.kendra.model.GitHubConfiguration.wrap(buildAwsValue())
}
object GitHubConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GitHubConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GitHubConfiguration =
      zio.aws.kendra.model.GitHubConfiguration(
        saaSConfiguration.map(value => value.asEditable),
        onPremiseConfiguration.map(value => value.asEditable),
        `type`.map(value => value),
        secretArn,
        useChangeLog.map(value => value),
        gitHubDocumentCrawlProperties.map(value => value.asEditable),
        repositoryFilter.map(value => value),
        inclusionFolderNamePatterns.map(value => value),
        inclusionFileTypePatterns.map(value => value),
        inclusionFileNamePatterns.map(value => value),
        exclusionFolderNamePatterns.map(value => value),
        exclusionFileTypePatterns.map(value => value),
        exclusionFileNamePatterns.map(value => value),
        vpcConfiguration.map(value => value.asEditable),
        gitHubRepositoryConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gitHubCommitConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gitHubIssueDocumentConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gitHubIssueCommentConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gitHubIssueAttachmentConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gitHubPullRequestCommentConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gitHubPullRequestDocumentConfigurationFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gitHubPullRequestDocumentAttachmentConfigurationFieldMappings.map(
          value =>
            value.map { item =>
              item.asEditable
            }
        )
      )
    def saaSConfiguration
        : Optional[zio.aws.kendra.model.SaaSConfiguration.ReadOnly]
    def onPremiseConfiguration
        : Optional[zio.aws.kendra.model.OnPremiseConfiguration.ReadOnly]
    def `type`: Optional[zio.aws.kendra.model.Type]
    def secretArn: SecretArn
    def useChangeLog: Optional[Boolean]
    def gitHubDocumentCrawlProperties
        : Optional[zio.aws.kendra.model.GitHubDocumentCrawlProperties.ReadOnly]
    def repositoryFilter: Optional[List[RepositoryName]]
    def inclusionFolderNamePatterns: Optional[List[String]]
    def inclusionFileTypePatterns: Optional[List[String]]
    def inclusionFileNamePatterns: Optional[List[String]]
    def exclusionFolderNamePatterns: Optional[List[String]]
    def exclusionFileTypePatterns: Optional[List[String]]
    def exclusionFileNamePatterns: Optional[List[String]]
    def vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def gitHubRepositoryConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def gitHubCommitConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def gitHubIssueDocumentConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def gitHubIssueCommentConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def gitHubIssueAttachmentConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def gitHubPullRequestCommentConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def gitHubPullRequestDocumentConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def gitHubPullRequestDocumentAttachmentConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def getSaaSConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.SaaSConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("saaSConfiguration", saaSConfiguration)
    def getOnPremiseConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.OnPremiseConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onPremiseConfiguration",
      onPremiseConfiguration
    )
    def getType: ZIO[Any, AwsError, zio.aws.kendra.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getUseChangeLog: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useChangeLog", useChangeLog)
    def getGitHubDocumentCrawlProperties: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.GitHubDocumentCrawlProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "gitHubDocumentCrawlProperties",
      gitHubDocumentCrawlProperties
    )
    def getRepositoryFilter: ZIO[Any, AwsError, List[RepositoryName]] =
      AwsError.unwrapOptionField("repositoryFilter", repositoryFilter)
    def getInclusionFolderNamePatterns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "inclusionFolderNamePatterns",
        inclusionFolderNamePatterns
      )
    def getInclusionFileTypePatterns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "inclusionFileTypePatterns",
        inclusionFileTypePatterns
      )
    def getInclusionFileNamePatterns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "inclusionFileNamePatterns",
        inclusionFileNamePatterns
      )
    def getExclusionFolderNamePatterns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "exclusionFolderNamePatterns",
        exclusionFolderNamePatterns
      )
    def getExclusionFileTypePatterns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "exclusionFileTypePatterns",
        exclusionFileTypePatterns
      )
    def getExclusionFileNamePatterns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "exclusionFileNamePatterns",
        exclusionFileNamePatterns
      )
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getGitHubRepositoryConfigurationFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "gitHubRepositoryConfigurationFieldMappings",
      gitHubRepositoryConfigurationFieldMappings
    )
    def getGitHubCommitConfigurationFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "gitHubCommitConfigurationFieldMappings",
      gitHubCommitConfigurationFieldMappings
    )
    def getGitHubIssueDocumentConfigurationFieldMappings
        : ZIO[Any, AwsError, List[
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "gitHubIssueDocumentConfigurationFieldMappings",
      gitHubIssueDocumentConfigurationFieldMappings
    )
    def getGitHubIssueCommentConfigurationFieldMappings
        : ZIO[Any, AwsError, List[
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "gitHubIssueCommentConfigurationFieldMappings",
      gitHubIssueCommentConfigurationFieldMappings
    )
    def getGitHubIssueAttachmentConfigurationFieldMappings
        : ZIO[Any, AwsError, List[
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "gitHubIssueAttachmentConfigurationFieldMappings",
      gitHubIssueAttachmentConfigurationFieldMappings
    )
    def getGitHubPullRequestCommentConfigurationFieldMappings
        : ZIO[Any, AwsError, List[
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "gitHubPullRequestCommentConfigurationFieldMappings",
      gitHubPullRequestCommentConfigurationFieldMappings
    )
    def getGitHubPullRequestDocumentConfigurationFieldMappings
        : ZIO[Any, AwsError, List[
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "gitHubPullRequestDocumentConfigurationFieldMappings",
      gitHubPullRequestDocumentConfigurationFieldMappings
    )
    def getGitHubPullRequestDocumentAttachmentConfigurationFieldMappings
        : ZIO[Any, AwsError, List[
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "gitHubPullRequestDocumentAttachmentConfigurationFieldMappings",
      gitHubPullRequestDocumentAttachmentConfigurationFieldMappings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GitHubConfiguration
  ) extends zio.aws.kendra.model.GitHubConfiguration.ReadOnly {
    override val saaSConfiguration
        : Optional[zio.aws.kendra.model.SaaSConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.saaSConfiguration())
        .map(value => zio.aws.kendra.model.SaaSConfiguration.wrap(value))
    override val onPremiseConfiguration
        : Optional[zio.aws.kendra.model.OnPremiseConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onPremiseConfiguration())
        .map(value => zio.aws.kendra.model.OnPremiseConfiguration.wrap(value))
    override val `type`: Optional[zio.aws.kendra.model.Type] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.kendra.model.Type.wrap(value))
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val useChangeLog: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useChangeLog())
      .map(value => value: Boolean)
    override val gitHubDocumentCrawlProperties: Optional[
      zio.aws.kendra.model.GitHubDocumentCrawlProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gitHubDocumentCrawlProperties())
      .map(value =>
        zio.aws.kendra.model.GitHubDocumentCrawlProperties.wrap(value)
      )
    override val repositoryFilter: Optional[List[RepositoryName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryFilter())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives.RepositoryName(item)
          }.toList
        )
    override val inclusionFolderNamePatterns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionFolderNamePatterns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val inclusionFileTypePatterns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionFileTypePatterns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val inclusionFileNamePatterns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionFileNamePatterns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val exclusionFolderNamePatterns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionFolderNamePatterns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val exclusionFileTypePatterns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionFileTypePatterns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val exclusionFileNamePatterns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionFileNamePatterns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
    override val gitHubRepositoryConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gitHubRepositoryConfigurationFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val gitHubCommitConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gitHubCommitConfigurationFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val gitHubIssueDocumentConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.gitHubIssueDocumentConfigurationFieldMappings()
      )
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val gitHubIssueCommentConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gitHubIssueCommentConfigurationFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val gitHubIssueAttachmentConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.gitHubIssueAttachmentConfigurationFieldMappings()
      )
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val gitHubPullRequestCommentConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.gitHubPullRequestCommentConfigurationFieldMappings()
      )
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val gitHubPullRequestDocumentConfigurationFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.gitHubPullRequestDocumentConfigurationFieldMappings()
      )
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val gitHubPullRequestDocumentAttachmentConfigurationFieldMappings
        : Optional[
          List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
        ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings()
      )
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GitHubConfiguration
  ): zio.aws.kendra.model.GitHubConfiguration.ReadOnly = new Wrapper(impl)
}
