package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GroupMembers(
    memberGroups: Optional[Iterable[zio.aws.kendra.model.MemberGroup]] =
      Optional.Absent,
    memberUsers: Optional[Iterable[zio.aws.kendra.model.MemberUser]] =
      Optional.Absent,
    s3PathforGroupMembers: Optional[zio.aws.kendra.model.S3Path] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GroupMembers = {
    import GroupMembers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GroupMembers
      .builder()
      .optionallyWith(
        memberGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memberGroups)
      .optionallyWith(
        memberUsers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memberUsers)
      .optionallyWith(
        s3PathforGroupMembers.map(value => value.buildAwsValue())
      )(_.s3PathforGroupMembers)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GroupMembers.ReadOnly =
    zio.aws.kendra.model.GroupMembers.wrap(buildAwsValue())
}
object GroupMembers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GroupMembers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GroupMembers =
      zio.aws.kendra.model.GroupMembers(
        memberGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        memberUsers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        s3PathforGroupMembers.map(value => value.asEditable)
      )
    def memberGroups: Optional[List[zio.aws.kendra.model.MemberGroup.ReadOnly]]
    def memberUsers: Optional[List[zio.aws.kendra.model.MemberUser.ReadOnly]]
    def s3PathforGroupMembers: Optional[zio.aws.kendra.model.S3Path.ReadOnly]
    def getMemberGroups
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.MemberGroup.ReadOnly]] =
      AwsError.unwrapOptionField("memberGroups", memberGroups)
    def getMemberUsers
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.MemberUser.ReadOnly]] =
      AwsError.unwrapOptionField("memberUsers", memberUsers)
    def getS3PathforGroupMembers
        : ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("s3PathforGroupMembers", s3PathforGroupMembers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GroupMembers
  ) extends zio.aws.kendra.model.GroupMembers.ReadOnly {
    override val memberGroups
        : Optional[List[zio.aws.kendra.model.MemberGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.MemberGroup.wrap(item)
          }.toList
        )
    override val memberUsers
        : Optional[List[zio.aws.kendra.model.MemberUser.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberUsers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.MemberUser.wrap(item)
          }.toList
        )
    override val s3PathforGroupMembers
        : Optional[zio.aws.kendra.model.S3Path.ReadOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.s3PathforGroupMembers())
      .map(value => zio.aws.kendra.model.S3Path.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GroupMembers
  ): zio.aws.kendra.model.GroupMembers.ReadOnly = new Wrapper(impl)
}
