package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{PrincipalOrderingId, GroupId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GroupSummary(
    groupId: Optional[GroupId] = Optional.Absent,
    orderingId: Optional[PrincipalOrderingId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GroupSummary = {
    import GroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GroupSummary
      .builder()
      .optionallyWith(
        groupId.map(value => GroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        orderingId.map(value =>
          PrincipalOrderingId.unwrap(value): java.lang.Long
        )
      )(_.orderingId)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GroupSummary.ReadOnly =
    zio.aws.kendra.model.GroupSummary.wrap(buildAwsValue())
}
object GroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GroupSummary = zio.aws.kendra.model
      .GroupSummary(groupId.map(value => value), orderingId.map(value => value))
    def groupId: Optional[GroupId]
    def orderingId: Optional[PrincipalOrderingId]
    def getGroupId: ZIO[Any, AwsError, GroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getOrderingId: ZIO[Any, AwsError, PrincipalOrderingId] =
      AwsError.unwrapOptionField("orderingId", orderingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GroupSummary
  ) extends zio.aws.kendra.model.GroupSummary.ReadOnly {
    override val groupId: Optional[GroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.kendra.model.primitives.GroupId(value))
    override val orderingId: Optional[PrincipalOrderingId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderingId())
        .map(value =>
          zio.aws.kendra.model.primitives.PrincipalOrderingId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GroupSummary
  ): zio.aws.kendra.model.GroupSummary.ReadOnly = new Wrapper(impl)
}
