package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class HierarchicalPrincipal(
    principalList: Iterable[zio.aws.kendra.model.Principal]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal = {
    import HierarchicalPrincipal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal
      .builder()
      .principalList(principalList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly =
    zio.aws.kendra.model.HierarchicalPrincipal.wrap(buildAwsValue())
}
object HierarchicalPrincipal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.HierarchicalPrincipal =
      zio.aws.kendra.model.HierarchicalPrincipal(principalList.map { item =>
        item.asEditable
      })
    def principalList: List[zio.aws.kendra.model.Principal.ReadOnly]
    def getPrincipalList
        : ZIO[Any, Nothing, List[zio.aws.kendra.model.Principal.ReadOnly]] =
      ZIO.succeed(principalList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal
  ) extends zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly {
    override val principalList: List[zio.aws.kendra.model.Principal.ReadOnly] =
      impl
        .principalList()
        .asScala
        .map { item =>
          zio.aws.kendra.model.Principal.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal
  ): zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly = new Wrapper(impl)
}
