package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait HighlightType {
  def unwrap: software.amazon.awssdk.services.kendra.model.HighlightType
}
object HighlightType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.HighlightType
  ): zio.aws.kendra.model.HighlightType = value match {
    case software.amazon.awssdk.services.kendra.model.HighlightType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.HighlightType.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.kendra.model.HighlightType.THESAURUS_SYNONYM =>
      val r = THESAURUS_SYNONYM
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.HighlightType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.HighlightType =
      software.amazon.awssdk.services.kendra.model.HighlightType.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.kendra.model.HighlightType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.HighlightType =
      software.amazon.awssdk.services.kendra.model.HighlightType.STANDARD
  }
  case object THESAURUS_SYNONYM extends zio.aws.kendra.model.HighlightType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.HighlightType =
      software.amazon.awssdk.services.kendra.model.HighlightType.THESAURUS_SYNONYM
  }
}
