package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InlineCustomDocumentEnrichmentConfiguration(
    condition: Optional[zio.aws.kendra.model.DocumentAttributeCondition] =
      Optional.Absent,
    target: Optional[zio.aws.kendra.model.DocumentAttributeTarget] =
      Optional.Absent,
    documentContentDeletion: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration = {
    import InlineCustomDocumentEnrichmentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration
      .builder()
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(
        documentContentDeletion.map(value => value: java.lang.Boolean)
      )(_.documentContentDeletion)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly =
    zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration
      .wrap(buildAwsValue())
}
object InlineCustomDocumentEnrichmentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration =
      zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration(
        condition.map(value => value.asEditable),
        target.map(value => value.asEditable),
        documentContentDeletion.map(value => value)
      )
    def condition
        : Optional[zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly]
    def target: Optional[zio.aws.kendra.model.DocumentAttributeTarget.ReadOnly]
    def documentContentDeletion: Optional[Boolean]
    def getCondition: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly
    ] = AwsError.unwrapOptionField("condition", condition)
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DocumentAttributeTarget.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getDocumentContentDeletion: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("documentContentDeletion", documentContentDeletion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration
  ) extends zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly {
    override val condition
        : Optional[zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.condition())
        .map(value =>
          zio.aws.kendra.model.DocumentAttributeCondition.wrap(value)
        )
    override val target
        : Optional[zio.aws.kendra.model.DocumentAttributeTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.target())
        .map(value => zio.aws.kendra.model.DocumentAttributeTarget.wrap(value))
    override val documentContentDeletion: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentContentDeletion())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration
  ): zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly =
    new Wrapper(impl)
}
