package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  SecretArn,
  JiraAccountUrl
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JiraConfiguration(
    jiraAccountUrl: JiraAccountUrl,
    secretArn: SecretArn,
    useChangeLog: Optional[Boolean] = Optional.Absent,
    project: Optional[Iterable[String]] = Optional.Absent,
    issueType: Optional[Iterable[String]] = Optional.Absent,
    status: Optional[Iterable[String]] = Optional.Absent,
    issueSubEntityFilter: Optional[
      Iterable[zio.aws.kendra.model.IssueSubEntity]
    ] = Optional.Absent,
    attachmentFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    commentFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    issueFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    projectFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    workLogFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    inclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    exclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    vpcConfiguration: Optional[
      zio.aws.kendra.model.DataSourceVpcConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.JiraConfiguration = {
    import JiraConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.JiraConfiguration
      .builder()
      .jiraAccountUrl(JiraAccountUrl.unwrap(jiraAccountUrl): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .optionallyWith(useChangeLog.map(value => value: java.lang.Boolean))(
        _.useChangeLog
      )
      .optionallyWith(
        project.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.project)
      .optionallyWith(
        issueType.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.issueType)
      .optionallyWith(
        status.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.status)
      .optionallyWith(
        issueSubEntityFilter.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.issueSubEntityFilterWithStrings)
      .optionallyWith(
        attachmentFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachmentFieldMappings)
      .optionallyWith(
        commentFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commentFieldMappings)
      .optionallyWith(
        issueFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.issueFieldMappings)
      .optionallyWith(
        projectFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectFieldMappings)
      .optionallyWith(
        workLogFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workLogFieldMappings)
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.JiraConfiguration.ReadOnly =
    zio.aws.kendra.model.JiraConfiguration.wrap(buildAwsValue())
}
object JiraConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.JiraConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.JiraConfiguration =
      zio.aws.kendra.model.JiraConfiguration(
        jiraAccountUrl,
        secretArn,
        useChangeLog.map(value => value),
        project.map(value => value),
        issueType.map(value => value),
        status.map(value => value),
        issueSubEntityFilter.map(value => value),
        attachmentFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        commentFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        issueFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projectFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workLogFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        vpcConfiguration.map(value => value.asEditable)
      )
    def jiraAccountUrl: JiraAccountUrl
    def secretArn: SecretArn
    def useChangeLog: Optional[Boolean]
    def project: Optional[List[String]]
    def issueType: Optional[List[String]]
    def status: Optional[List[String]]
    def issueSubEntityFilter
        : Optional[List[zio.aws.kendra.model.IssueSubEntity]]
    def attachmentFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def commentFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def issueFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def projectFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def workLogFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def getJiraAccountUrl: ZIO[Any, Nothing, JiraAccountUrl] =
      ZIO.succeed(jiraAccountUrl)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getUseChangeLog: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useChangeLog", useChangeLog)
    def getProject: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("project", project)
    def getIssueType: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("issueType", issueType)
    def getStatus: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("status", status)
    def getIssueSubEntityFilter
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.IssueSubEntity]] =
      AwsError.unwrapOptionField("issueSubEntityFilter", issueSubEntityFilter)
    def getAttachmentFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachmentFieldMappings",
      attachmentFieldMappings
    )
    def getCommentFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] =
      AwsError.unwrapOptionField("commentFieldMappings", commentFieldMappings)
    def getIssueFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("issueFieldMappings", issueFieldMappings)
    def getProjectFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] =
      AwsError.unwrapOptionField("projectFieldMappings", projectFieldMappings)
    def getWorkLogFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] =
      AwsError.unwrapOptionField("workLogFieldMappings", workLogFieldMappings)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.JiraConfiguration
  ) extends zio.aws.kendra.model.JiraConfiguration.ReadOnly {
    override val jiraAccountUrl: JiraAccountUrl =
      zio.aws.kendra.model.primitives.JiraAccountUrl(impl.jiraAccountUrl())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val useChangeLog: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useChangeLog())
      .map(value => value: Boolean)
    override val project: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.project())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val issueType: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.issueType())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val issueSubEntityFilter
        : Optional[List[zio.aws.kendra.model.IssueSubEntity]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.issueSubEntityFilter())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.IssueSubEntity.wrap(item)
          }.toList
        )
    override val attachmentFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val commentFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commentFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val issueFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.issueFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val projectFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.projectFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val workLogFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workLogFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.JiraConfiguration
  ): zio.aws.kendra.model.JiraConfiguration.ReadOnly = new Wrapper(impl)
}
