package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait KeyLocation {
  def unwrap: software.amazon.awssdk.services.kendra.model.KeyLocation
}
object KeyLocation {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.KeyLocation
  ): zio.aws.kendra.model.KeyLocation = value match {
    case software.amazon.awssdk.services.kendra.model.KeyLocation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.KeyLocation.URL =>
      val r = URL
      r
    case software.amazon.awssdk.services.kendra.model.KeyLocation.SECRET_MANAGER =>
      val r = SECRET_MANAGER
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.KeyLocation {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.KeyLocation =
      software.amazon.awssdk.services.kendra.model.KeyLocation.UNKNOWN_TO_SDK_VERSION
  }
  case object URL extends zio.aws.kendra.model.KeyLocation {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.KeyLocation =
      software.amazon.awssdk.services.kendra.model.KeyLocation.URL
  }
  case object SECRET_MANAGER extends zio.aws.kendra.model.KeyLocation {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.KeyLocation =
      software.amazon.awssdk.services.kendra.model.KeyLocation.SECRET_MANAGER
  }
}
