package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListEntityPersonasRequest,
  NextToken,
  IndexId,
  ExperienceId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEntityPersonasRequest(
    id: ExperienceId,
    indexId: IndexId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsIntegerForListEntityPersonasRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest = {
    import ListEntityPersonasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest
      .builder()
      .id(ExperienceId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListEntityPersonasRequest.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListEntityPersonasRequest.ReadOnly =
    zio.aws.kendra.model.ListEntityPersonasRequest.wrap(buildAwsValue())
}
object ListEntityPersonasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListEntityPersonasRequest =
      zio.aws.kendra.model.ListEntityPersonasRequest(
        id,
        indexId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def id: ExperienceId
    def indexId: IndexId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsIntegerForListEntityPersonasRequest]
    def getId: ZIO[Any, Nothing, ExperienceId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, MaxResultsIntegerForListEntityPersonasRequest] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest
  ) extends zio.aws.kendra.model.ListEntityPersonasRequest.ReadOnly {
    override val id: ExperienceId =
      zio.aws.kendra.model.primitives.ExperienceId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults
        : Optional[MaxResultsIntegerForListEntityPersonasRequest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kendra.model.primitives
            .MaxResultsIntegerForListEntityPersonasRequest(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest
  ): zio.aws.kendra.model.ListEntityPersonasRequest.ReadOnly = new Wrapper(impl)
}
