package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEntityPersonasResponse(
    summaryItems: Optional[Iterable[zio.aws.kendra.model.PersonasSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse = {
    import ListEntityPersonasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse
      .builder()
      .optionallyWith(
        summaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListEntityPersonasResponse.ReadOnly =
    zio.aws.kendra.model.ListEntityPersonasResponse.wrap(buildAwsValue())
}
object ListEntityPersonasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListEntityPersonasResponse =
      zio.aws.kendra.model.ListEntityPersonasResponse(
        summaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaryItems
        : Optional[List[zio.aws.kendra.model.PersonasSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.PersonasSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaryItems", summaryItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse
  ) extends zio.aws.kendra.model.ListEntityPersonasResponse.ReadOnly {
    override val summaryItems
        : Optional[List[zio.aws.kendra.model.PersonasSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summaryItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.PersonasSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse
  ): zio.aws.kendra.model.ListEntityPersonasResponse.ReadOnly = new Wrapper(
    impl
  )
}
