package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{NextToken, IndexId, ExperienceId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListExperienceEntitiesRequest(
    id: ExperienceId,
    indexId: IndexId,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest = {
    import ListExperienceEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest
      .builder()
      .id(ExperienceId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListExperienceEntitiesRequest.ReadOnly =
    zio.aws.kendra.model.ListExperienceEntitiesRequest.wrap(buildAwsValue())
}
object ListExperienceEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListExperienceEntitiesRequest =
      zio.aws.kendra.model.ListExperienceEntitiesRequest(
        id,
        indexId,
        nextToken.map(value => value)
      )
    def id: ExperienceId
    def indexId: IndexId
    def nextToken: Optional[NextToken]
    def getId: ZIO[Any, Nothing, ExperienceId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest
  ) extends zio.aws.kendra.model.ListExperienceEntitiesRequest.ReadOnly {
    override val id: ExperienceId =
      zio.aws.kendra.model.primitives.ExperienceId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest
  ): zio.aws.kendra.model.ListExperienceEntitiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
