package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListExperiencesResponse(
    summaryItems: Optional[Iterable[zio.aws.kendra.model.ExperiencesSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListExperiencesResponse = {
    import ListExperiencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListExperiencesResponse
      .builder()
      .optionallyWith(
        summaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListExperiencesResponse.ReadOnly =
    zio.aws.kendra.model.ListExperiencesResponse.wrap(buildAwsValue())
}
object ListExperiencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListExperiencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListExperiencesResponse =
      zio.aws.kendra.model.ListExperiencesResponse(
        summaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaryItems
        : Optional[List[zio.aws.kendra.model.ExperiencesSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ExperiencesSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaryItems", summaryItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListExperiencesResponse
  ) extends zio.aws.kendra.model.ListExperiencesResponse.ReadOnly {
    override val summaryItems
        : Optional[List[zio.aws.kendra.model.ExperiencesSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summaryItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.ExperiencesSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListExperiencesResponse
  ): zio.aws.kendra.model.ListExperiencesResponse.ReadOnly = new Wrapper(impl)
}
