package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListFaqsRequest,
  NextToken,
  IndexId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListFaqsRequest(
    indexId: IndexId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsIntegerForListFaqsRequest] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListFaqsRequest = {
    import ListFaqsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListFaqsRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListFaqsRequest.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListFaqsRequest.ReadOnly =
    zio.aws.kendra.model.ListFaqsRequest.wrap(buildAwsValue())
}
object ListFaqsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListFaqsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListFaqsRequest =
      zio.aws.kendra.model.ListFaqsRequest(
        indexId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def indexId: IndexId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsIntegerForListFaqsRequest]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsIntegerForListFaqsRequest] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListFaqsRequest
  ) extends zio.aws.kendra.model.ListFaqsRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResultsIntegerForListFaqsRequest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kendra.model.primitives
            .MaxResultsIntegerForListFaqsRequest(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListFaqsRequest
  ): zio.aws.kendra.model.ListFaqsRequest.ReadOnly = new Wrapper(impl)
}
