package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListFeaturedResultsSetsRequest,
  NextToken,
  IndexId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListFeaturedResultsSetsRequest(
    indexId: IndexId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsIntegerForListFeaturedResultsSetsRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsRequest = {
    import ListFeaturedResultsSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListFeaturedResultsSetsRequest.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListFeaturedResultsSetsRequest.ReadOnly =
    zio.aws.kendra.model.ListFeaturedResultsSetsRequest.wrap(buildAwsValue())
}
object ListFeaturedResultsSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListFeaturedResultsSetsRequest =
      zio.aws.kendra.model.ListFeaturedResultsSetsRequest(
        indexId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def indexId: IndexId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsIntegerForListFeaturedResultsSetsRequest]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      MaxResultsIntegerForListFeaturedResultsSetsRequest
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsRequest
  ) extends zio.aws.kendra.model.ListFeaturedResultsSetsRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults
        : Optional[MaxResultsIntegerForListFeaturedResultsSetsRequest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kendra.model.primitives
            .MaxResultsIntegerForListFeaturedResultsSetsRequest(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsRequest
  ): zio.aws.kendra.model.ListFeaturedResultsSetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
