package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFeaturedResultsSetsResponse(
    featuredResultsSetSummaryItems: Optional[
      Iterable[zio.aws.kendra.model.FeaturedResultsSetSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsResponse = {
    import ListFeaturedResultsSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsResponse
      .builder()
      .optionallyWith(
        featuredResultsSetSummaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.featuredResultsSetSummaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ListFeaturedResultsSetsResponse.ReadOnly =
    zio.aws.kendra.model.ListFeaturedResultsSetsResponse.wrap(buildAwsValue())
}
object ListFeaturedResultsSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListFeaturedResultsSetsResponse =
      zio.aws.kendra.model.ListFeaturedResultsSetsResponse(
        featuredResultsSetSummaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def featuredResultsSetSummaryItems: Optional[
      List[zio.aws.kendra.model.FeaturedResultsSetSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getFeaturedResultsSetSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.FeaturedResultsSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "featuredResultsSetSummaryItems",
      featuredResultsSetSummaryItems
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsResponse
  ) extends zio.aws.kendra.model.ListFeaturedResultsSetsResponse.ReadOnly {
    override val featuredResultsSetSummaryItems: Optional[
      List[zio.aws.kendra.model.FeaturedResultsSetSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.featuredResultsSetSummaryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.FeaturedResultsSetSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsResponse
  ): zio.aws.kendra.model.ListFeaturedResultsSetsResponse.ReadOnly =
    new Wrapper(impl)
}
