package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListGroupsOlderThanOrderingIdResponse(
    groupsSummaries: Optional[Iterable[zio.aws.kendra.model.GroupSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse = {
    import ListGroupsOlderThanOrderingIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse
      .builder()
      .optionallyWith(
        groupsSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupsSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse.ReadOnly =
    zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse
      .wrap(buildAwsValue())
}
object ListGroupsOlderThanOrderingIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse =
      zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse(
        groupsSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def groupsSummaries
        : Optional[List[zio.aws.kendra.model.GroupSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getGroupsSummaries
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.GroupSummary.ReadOnly]] =
      AwsError.unwrapOptionField("groupsSummaries", groupsSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse
  ) extends zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse.ReadOnly {
    override val groupsSummaries
        : Optional[List[zio.aws.kendra.model.GroupSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupsSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.GroupSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse
  ): zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse.ReadOnly =
    new Wrapper(impl)
}
