package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListQuerySuggestionsBlockListsResponse(
    blockListSummaryItems: Optional[
      Iterable[zio.aws.kendra.model.QuerySuggestionsBlockListSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse = {
    import ListQuerySuggestionsBlockListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse
      .builder()
      .optionallyWith(
        blockListSummaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockListSummaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.ReadOnly =
    zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse
      .wrap(buildAwsValue())
}
object ListQuerySuggestionsBlockListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse =
      zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse(
        blockListSummaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def blockListSummaryItems: Optional[
      List[zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getBlockListSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("blockListSummaryItems", blockListSummaryItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse
  ) extends zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.ReadOnly {
    override val blockListSummaryItems: Optional[
      List[zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blockListSummaryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.QuerySuggestionsBlockListSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse
  ): zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.ReadOnly =
    new Wrapper(impl)
}
