package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.UserId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MemberUser(userId: UserId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.MemberUser = {
    import MemberUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.MemberUser
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.MemberUser.ReadOnly =
    zio.aws.kendra.model.MemberUser.wrap(buildAwsValue())
}
object MemberUser {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.MemberUser] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.MemberUser =
      zio.aws.kendra.model.MemberUser(userId)
    def userId: UserId
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.MemberUser
  ) extends zio.aws.kendra.model.MemberUser.ReadOnly {
    override val userId: UserId =
      zio.aws.kendra.model.primitives.UserId(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.MemberUser
  ): zio.aws.kendra.model.MemberUser.ReadOnly = new Wrapper(impl)
}
