package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait MetricType {
  def unwrap: software.amazon.awssdk.services.kendra.model.MetricType
}
object MetricType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.MetricType
  ): zio.aws.kendra.model.MetricType = value match {
    case software.amazon.awssdk.services.kendra.model.MetricType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.MetricType.QUERIES_BY_COUNT =>
      val r = QUERIES_BY_COUNT
      r
    case software.amazon.awssdk.services.kendra.model.MetricType.QUERIES_BY_ZERO_CLICK_RATE =>
      val r = QUERIES_BY_ZERO_CLICK_RATE
      r
    case software.amazon.awssdk.services.kendra.model.MetricType.QUERIES_BY_ZERO_RESULT_RATE =>
      val r = QUERIES_BY_ZERO_RESULT_RATE
      r
    case software.amazon.awssdk.services.kendra.model.MetricType.DOCS_BY_CLICK_COUNT =>
      val r = DOCS_BY_CLICK_COUNT
      r
    case software.amazon.awssdk.services.kendra.model.MetricType.AGG_QUERY_DOC_METRICS =>
      val r = AGG_QUERY_DOC_METRICS
      r
    case software.amazon.awssdk.services.kendra.model.MetricType.TREND_QUERY_DOC_METRICS =>
      val r = TREND_QUERY_DOC_METRICS
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.MetricType =
      software.amazon.awssdk.services.kendra.model.MetricType.UNKNOWN_TO_SDK_VERSION
  }
  case object QUERIES_BY_COUNT extends zio.aws.kendra.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.MetricType =
      software.amazon.awssdk.services.kendra.model.MetricType.QUERIES_BY_COUNT
  }
  case object QUERIES_BY_ZERO_CLICK_RATE
      extends zio.aws.kendra.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.MetricType =
      software.amazon.awssdk.services.kendra.model.MetricType.QUERIES_BY_ZERO_CLICK_RATE
  }
  case object QUERIES_BY_ZERO_RESULT_RATE
      extends zio.aws.kendra.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.MetricType =
      software.amazon.awssdk.services.kendra.model.MetricType.QUERIES_BY_ZERO_RESULT_RATE
  }
  case object DOCS_BY_CLICK_COUNT extends zio.aws.kendra.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.MetricType =
      software.amazon.awssdk.services.kendra.model.MetricType.DOCS_BY_CLICK_COUNT
  }
  case object AGG_QUERY_DOC_METRICS extends zio.aws.kendra.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.MetricType =
      software.amazon.awssdk.services.kendra.model.MetricType.AGG_QUERY_DOC_METRICS
  }
  case object TREND_QUERY_DOC_METRICS extends zio.aws.kendra.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.MetricType =
      software.amazon.awssdk.services.kendra.model.MetricType.TREND_QUERY_DOC_METRICS
  }
}
