package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait MissingAttributeKeyStrategy {
  def unwrap
      : software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy
}
object MissingAttributeKeyStrategy {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy
  ): zio.aws.kendra.model.MissingAttributeKeyStrategy = value match {
    case software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy.IGNORE =>
      val r = IGNORE
      r
    case software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy.COLLAPSE =>
      val r = COLLAPSE
      r
    case software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy.EXPAND =>
      val r = EXPAND
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.MissingAttributeKeyStrategy {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy =
      software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object IGNORE extends zio.aws.kendra.model.MissingAttributeKeyStrategy {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy =
      software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy.IGNORE
  }
  case object COLLAPSE
      extends zio.aws.kendra.model.MissingAttributeKeyStrategy {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy =
      software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy.COLLAPSE
  }
  case object EXPAND extends zio.aws.kendra.model.MissingAttributeKeyStrategy {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy =
      software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy.EXPAND
  }
}
