package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{OrganizationName, Url}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OnPremiseConfiguration(
    hostUrl: Url,
    organizationName: OrganizationName,
    sslCertificateS3Path: zio.aws.kendra.model.S3Path
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.OnPremiseConfiguration = {
    import OnPremiseConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.OnPremiseConfiguration
      .builder()
      .hostUrl(Url.unwrap(hostUrl): java.lang.String)
      .organizationName(
        OrganizationName.unwrap(organizationName): java.lang.String
      )
      .sslCertificateS3Path(sslCertificateS3Path.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.OnPremiseConfiguration.ReadOnly =
    zio.aws.kendra.model.OnPremiseConfiguration.wrap(buildAwsValue())
}
object OnPremiseConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.OnPremiseConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.OnPremiseConfiguration =
      zio.aws.kendra.model.OnPremiseConfiguration(
        hostUrl,
        organizationName,
        sslCertificateS3Path.asEditable
      )
    def hostUrl: Url
    def organizationName: OrganizationName
    def sslCertificateS3Path: zio.aws.kendra.model.S3Path.ReadOnly
    def getHostUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(hostUrl)
    def getOrganizationName: ZIO[Any, Nothing, OrganizationName] =
      ZIO.succeed(organizationName)
    def getSslCertificateS3Path
        : ZIO[Any, Nothing, zio.aws.kendra.model.S3Path.ReadOnly] =
      ZIO.succeed(sslCertificateS3Path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.OnPremiseConfiguration
  ) extends zio.aws.kendra.model.OnPremiseConfiguration.ReadOnly {
    override val hostUrl: Url =
      zio.aws.kendra.model.primitives.Url(impl.hostUrl())
    override val organizationName: OrganizationName =
      zio.aws.kendra.model.primitives.OrganizationName(impl.organizationName())
    override val sslCertificateS3Path: zio.aws.kendra.model.S3Path.ReadOnly =
      zio.aws.kendra.model.S3Path.wrap(impl.sslCertificateS3Path())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.OnPremiseConfiguration
  ): zio.aws.kendra.model.OnPremiseConfiguration.ReadOnly = new Wrapper(impl)
}
