package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.OneDriveUser
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OneDriveUsers(
    oneDriveUserList: Optional[Iterable[OneDriveUser]] = Optional.Absent,
    oneDriveUserS3Path: Optional[zio.aws.kendra.model.S3Path] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.OneDriveUsers = {
    import OneDriveUsers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.OneDriveUsers
      .builder()
      .optionallyWith(
        oneDriveUserList.map(value =>
          value.map { item =>
            OneDriveUser.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.oneDriveUserList)
      .optionallyWith(oneDriveUserS3Path.map(value => value.buildAwsValue()))(
        _.oneDriveUserS3Path
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.OneDriveUsers.ReadOnly =
    zio.aws.kendra.model.OneDriveUsers.wrap(buildAwsValue())
}
object OneDriveUsers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.OneDriveUsers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.OneDriveUsers =
      zio.aws.kendra.model.OneDriveUsers(
        oneDriveUserList.map(value => value),
        oneDriveUserS3Path.map(value => value.asEditable)
      )
    def oneDriveUserList: Optional[List[OneDriveUser]]
    def oneDriveUserS3Path: Optional[zio.aws.kendra.model.S3Path.ReadOnly]
    def getOneDriveUserList: ZIO[Any, AwsError, List[OneDriveUser]] =
      AwsError.unwrapOptionField("oneDriveUserList", oneDriveUserList)
    def getOneDriveUserS3Path
        : ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("oneDriveUserS3Path", oneDriveUserS3Path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.OneDriveUsers
  ) extends zio.aws.kendra.model.OneDriveUsers.ReadOnly {
    override val oneDriveUserList: Optional[List[OneDriveUser]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oneDriveUserList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives.OneDriveUser(item)
          }.toList
        )
    override val oneDriveUserS3Path
        : Optional[zio.aws.kendra.model.S3Path.ReadOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.oneDriveUserS3Path())
      .map(value => zio.aws.kendra.model.S3Path.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.OneDriveUsers
  ): zio.aws.kendra.model.OneDriveUsers.ReadOnly = new Wrapper(impl)
}
