package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait Persona {
  def unwrap: software.amazon.awssdk.services.kendra.model.Persona
}
object Persona {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.Persona
  ): zio.aws.kendra.model.Persona = value match {
    case software.amazon.awssdk.services.kendra.model.Persona.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.Persona.OWNER =>
      val r = OWNER
      r
    case software.amazon.awssdk.services.kendra.model.Persona.VIEWER =>
      val r = VIEWER
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.Persona {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Persona =
      software.amazon.awssdk.services.kendra.model.Persona.UNKNOWN_TO_SDK_VERSION
  }
  case object OWNER extends zio.aws.kendra.model.Persona {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Persona =
      software.amazon.awssdk.services.kendra.model.Persona.OWNER
  }
  case object VIEWER extends zio.aws.kendra.model.Persona {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Persona =
      software.amazon.awssdk.services.kendra.model.Persona.VIEWER
  }
}
